var whatIsMain_el = null;
var whatIsBar_el = null;
var whatIsLeftColumn_el = null;
var whatIsRightColumn_el = null;

var previewBar_el = null;
var thumbsHolder_el = null;

var mainFeaturesMain_el = null;
var mainFeaturesBar_el = null;
var mainFeaturesLeftColumn_el = null;
var mainFeaturesRightColumn_el = null;

var lightboxMain_el = null;
var lightboxBar_el = null;
var lightboxLeftColumn_el = null;
var lightboxRightColumn_el = null;

var whatIs_img = null;
var logoImage_img = null;
var html5_img = null;
var byFWD_img = null;
var openedWindow = null;

var mainWidth = 940;
var byFWDImageWidth = 70;
var html5ImageWidth = 90;
var logoImageWidth = 940;
var windowW = 0;
var windowH = 0;

var resizeHandlerId_to;
var removeIcons_to;


//##################################//
/* initialize page */
//##################################//
function init(){

	whatIsMain_el = document.getElementById("whatIsMain");
	whatIsBar_el = document.getElementById("whatIsBar");
	whatIsLeftColumn_el = document.getElementById("whatIsLeftColumn");
	whatIsRightColumn_el = document.getElementById("whatIsRightColumn");
	
	previewBar_el = document.getElementById("preview");
	thumbsHolder_el = document.getElementById("thumbsHolder");
	
	mainFeaturesMain_el = document.getElementById("mainFeaturesMain");
	mainFeaturesBar_el = document.getElementById("mainFeaturesBar");
	mainFeaturesLeftColumn_el = document.getElementById("mainFeaturesLeftColumn");
	mainFeaturesRightColumn_el = document.getElementById("mainFeaturesRightColumn");
	
	lightboxMain_el = document.getElementById("lightboxMain");
	lightboxBar_el = document.getElementById("lightboxBar");
	lightboxLeftColumn_el = document.getElementById("lightboxLeftColumn");
	lightboxRightColumn_el = document.getElementById("lightboxRightColumn");
	
	html5_img = document.getElementById("html5");
	logoImage_img = document.getElementById("logoImage");
	byFWD_img = document.getElementById("byFWD");
	byFWD_img.style.cursor = "pointer";
	byFWD_img.onclick = function(){
		window.location.href = "http://www.webdesign-flash.ro";
	};
	
	setupThumbsHolder();
	positionStuff();

	if(window.addEventListener){
		window.addEventListener("resize", onResizeHandler);
	}else if(window.attachEvent){
		window.attachEvent("onresize", onResizeHandler);
	}
	
	setTimeout( function(){
		positionStuff();
		}, 50);
}

//#####################################//
/* resize handler */
//#####################################//
function onResizeHandler(){
	if(FWDUtils.isMobile){
		clearTimeout(resizeHandlerId_to); 
		resizeHandlerId_to = setTimeout(positionStuff, 90);
	}else{
		positionStuff();
		clearTimeout(resizeHandlerId_to); 
		resizeHandlerId_to = setTimeout(positionStuff, 90);
	}
}

//#####################################//
/* position stuff */
//#####################################//
function positionStuff(){
	windowW = document.documentElement.clientWidth || window.innerWidth;
	windowH = document.documentElement.clientHeight || window.innerHeight;
	
	positionLogoImage();
	pageThumbs_do.positionAndResize(windowW);
	resizeText();
}

//#####################################//
/* Setup page thumbs */
//####################################//
function setupThumbsHolder(){
	FWDPageThumbs.setPrototype();
	pageThumbs_do = new FWDPageThumbs({
		parent:thumbsHolder_el,
		imagesPath:[ "read_more_graphics/minimalDark1.jpg", 
		            "read_more_graphics/minimalDark2.jpg", 
		            "read_more_graphics/minimalDark3.jpg",
		            "read_more_graphics/modern1.jpg", 
		            "read_more_graphics/modern2.jpg", 
		            "read_more_graphics/modern3.jpg",
		            "read_more_graphics/modernColored1.jpg", 
		            "read_more_graphics/modernColored2.jpg", 
		            "read_more_graphics/modernColored3.jpg"],
		imageOverPath:"cutout_round_silver_graphics/over.png",
		labels:["Minimal square skin responsive layout with multiple categories example 1", 
		        "Minimal round skin fixed layout with single category", 
		        "Minimal square skin responsive layout with multiple categories example 2",
		        "Modern square skin responsive layout with multiple categories example 1", 
		        "Modern round skin fixed layout with single category", 
		        "Modern square skin responsive layout with multiple categories example 2",
		        "Modern colored square skin responsive layout with multiple categories example 1", 
		        "Modern round square skin fixed layout with single category", 
		        "Modern colored square skin responsive layout with multiple categories example 2"],
		thumbShadowPath:"cutout_round_silver_graphics/thumbShadow.jpg",
		thumbShadowPath:"cutout_round_silver_graphics/thumbShadow.jpg",
		maxWidth:mainWidth,
		thumbnailBorderColor:"#ababab",
		textNormalColor:"#FFFFFF",
		textSelectedColor:"#000000",
		wiewSampleTextColor:"#FFFFFF",
		shadowOffsetX:2,
		shadowOffsetY:2,
		shadowOffsetW:-4,
		shadowOffsetH:-4
	});
	
	pageThumbs_do.addListener(FWDPageThumb.CLICK, onThumbPressedHandler);
}


function onThumbPressedHandler(e){
	
	var newY;
	
	if(openedWindow){
		try{
			openedWindow.close();
		}catch(e){}
		openedWindow = null;
	}

	if(e.id == 0){
		openedWindow = window.open("minimal-dark1.html");
	}else if(e.id == 1){
		openedWindow = window.open("minimal-dark2.html");
	}else if(e.id == 2){
		openedWindow = window.open("minimal-dark3.html");
	}else if(e.id == 3){
		openedWindow = window.open("modern1.html");
	}else if(e.id == 4){
		openedWindow = window.open("modern2.html");
	}else if(e.id == 5){
		openedWindow = window.open("modern3.html");
	}else if(e.id == 6){
		openedWindow = window.open("modern-colored1.html");
	}else if(e.id == 7){
		openedWindow = window.open("modern-colored2.html");
	}else if(e.id == 8){
		openedWindow = window.open("modern-colored3.html");
	}
}

//#####################################//
/* position logo image */
//#####################################//
function positionLogoImage(){
	var html5X = 16;
	var byFWDX = (windowW - byFWDImageWidth - 2);
	var logoImageX = parseInt((windowW - logoImageWidth)/2);
	
	if(byFWDX > mainWidth - byFWDImageWidth){
		byFWDX =  parseInt(logoImageX  + logoImageWidth - byFWDImageWidth);
	}
	
	if(windowW < mainWidth){
		html5X = 2;
	}else{
		html5X = logoImageX;
	}
	
	if(windowW < 500){
		byFWD_img.style.top = "-50px";
		html5_img.style.top = "-50px";
	}else{
		byFWD_img.style.top = "90px";
		html5_img.style.top = "78px";
	}
	
	html5_img.style.left =  html5X + "px";
	logoImage_img.style.left = logoImageX  + "px";
	byFWD_img.style.left = byFWDX + "px";
};

//#####################################//
/* position and resize text holder */
//#####################################//
function resizeText(){
	var finalW = Math.min(windowW, mainWidth);
	var textFinalW = finalW;
	
	if(textFinalW < mainWidth) textFinalW -= 20;
	if(textFinalW < 400){
		whatIsLeftColumn_el.style.display = "none";	
		mainFeaturesLeftColumn_el.style.display = "none";
		lightboxLeftColumn_el.style.display = "none";		
	}else{
		whatIsLeftColumn_el.style.display = "table-cell";	
		whatIsLeftColumn_el.style.textAlign = "center";	
		mainFeaturesLeftColumn_el.style.display = "table-cell";	
		mainFeaturesLeftColumn_el.style.textAlign = "center";	
		lightboxLeftColumn_el.style.display = "table-cell";	
		lightboxLeftColumn_el.style.textAlign = "center";	
	}
		
	whatIsMain_el.style.width = textFinalW  + "px";
	mainFeaturesMain_el.style.width = textFinalW  + "px";
	lightboxMain_el.style.width = textFinalW  + "px";
	previewBar_el.style.width = finalW  + "px";
	whatIsBar_el.style.width = finalW  + "px";
	mainFeaturesBar_el.style.width = finalW  + "px";
	lightboxBar_el.style.width = finalW  + "px";
}